
/*
	An applet for the game of Dominate!
	Author: Vassilis Papadimos 
	Date:  26/06/1996

	Based on Arthur Van Hoff's TicTacToe applet.
*/

import java.awt.*;
import java.awt.image.*;
import java.net.*;
import java.applet.*;

public
class Dominate extends Applet {

    static final int EMPTY = 0;
    static final int  RED = 1;
    static final int GREEN = 2;
    static final int SELECTED = 3;

    boolean first_selected;
    int selected_x, selected_y;
     
    int board[][]; 
	

    /**
     * Initialize the applet. Resize and load images.
     */
    public void init() {
	board = new int [10][10];
	first_selected = false;
	board[1][1] = GREEN;
	board[8][8] = RED;
    }

    /**
     * Paint it.
     */
    public void paint(Graphics g) {

	Dimension d = size();
	d.width = d.width - 10;
	d.height = d.height - 10;
	g.setColor(Color.black);
	int xoff = d.width / 10;
	int yoff = d.height / 10;
	int iline;
	for (iline=0; iline<11; iline++) {
		g.drawLine(iline*xoff, 0, iline*xoff, d.height);
		g.drawLine(0, iline*yoff, d.width, iline*yoff);
	}
	int i=0, j=0;
	for (i=0; i<10; i++)
		for (j=0; j<10; j++)
			if (board[i][j] == RED) {
				g.setColor(Color.red);
				g.fillRect(i*xoff, j*yoff, xoff, yoff);
			}
			else if (board[i][j] == GREEN) {
				g.setColor(Color.green);
				g.fillRect(i*xoff, j*yoff, xoff, yoff);
			}
	if (first_selected) {
		g.setColor(Color.pink);
		g.fillRect(selected_x * xoff, selected_y * yoff, xoff, yoff);
	}
				
    }

    /**
     * The user has cliched in the applet. Figure out where
     * and see if a legal move is possible. If it is a legal
     * move, respond with a legal move (if possible).
     */
    public boolean mouseUp(Event evt, int x, int y) {

	// Figure out the row/colum
	Dimension d = size();
	d.width = d.width - 10;
	d.height = d.height - 10;

	int c = (x * 10) / d.width;
	int r = (y * 10) / d.height;

	if (!first_selected) {
		if (board[c][r] == GREEN) {
			first_selected = true;
			selected_x = c; selected_y = r;
			repaint(); return true;
		}
		else 
			return true;
	}
	else {
		if (c == selected_x && r == selected_y) {
			first_selected = false;
			repaint(); return true;
		}
		else if (board[c][r] == EMPTY) {
			int diffx = Math.abs(c - selected_x);
			int diffy = Math.abs(r - selected_y);
		   if (diffx <=1 &&  diffy<=1) {
			first_selected = false;
			board[c][r] = GREEN;
			repaint(); return true;
		   }
		   else if ( ((diffx ==2) && diffy==0) 
			     || ((diffy == 2) && diffx ==0)) {
			first_selected = false;
			board[c][r] = GREEN;
			board[selected_x][selected_y] = EMPTY;
			repaint(); return true;
		  }
		}
		}
	return true;
}

    public String getAppletInfo() {
	return "Dominate by Vassilis Papadimos";
    }
}

