
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/*Ansi||color-vt100 escape sequences*/

#define RED "\033[31mR\033[7m \033[0m"
#define GREEN "\033[32mG\033[7m \033[0m"
#define REV "\033[7m# \033[0m"
#define CLEAR "\033[H\033[2J"

#define MAXDEPTH 1

#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define min(a,b)        (((a) < (b)) ? (a) : (b))

int eval();
int firstchild();
int nextbrother();

int map[10][10]; /*Holds gametable. Values:0 green, 1 red, 2 FREE */
int status=0,state;
int tbls[10][10];

/*The move function*/
move(x1,y1,x2,y2)
int x1,y1,x2,y2;
{

if ((map[x1][y1]-status%2)) { /*checks if piece you want to move is yours. Status%2 is 0 or 1 (green or red)*/ 
	printf("\nNot your piece\n");return 0;
	}
if (map[x2][y2]!=2) { /*map[x][y]=2 when free, see above for valid values*/
    printf("\nPiece occupied\n");return 0;
    }
if ((abs(x1-x2)<=1&&abs(y1-y2)<=1)) { /*One step*/
	map[x2][y2]=map[x1][y1];
	paint(x2,y2,map,status%2);
	status++; /*The other will play*/
	return 1;
    }

if ( abs(x1-x2) > 2 || abs(y1-y2) > 2 || ((x1-x2)&&(y1-y2))) { /*Two steps, jump*/
	printf("\nToo far away \n");return 0;
    }
	else {
		map[x2][y2]=map[x1][y1];
		map[x1][y1]=2;
		paint(x2,y2,map,status%2);
		status++;
		return 1;
	}

}

paint(x1,y1,table,color) /*redraws table if x1 y1 is painted:fixes the color changes*/
int x1,y1,table[10][10],color;
{
int l,r,u,d;

l=r=u=d=0; /*left right up down is 0: e.g. not free (starting value)*/

if (x1<9) {if (table[x1+1][y1]!=2) table[x1+1][y1]=table[x1][y1];r=color;}
if (x1>0) {if (table[x1-1][y1]!=2) table[x1-1][y1]=table[x1][y1];l=color;}

if (y1<9) {if (table[x1][y1+1]!=2) table[x1][y1+1]=table[x1][y1];d=color;}
if (y1>0) {if (table[x1][y1-1]!=2) table[x1][y1-1]=table[x1][y1];u=color;}

if (u&&l&&table[x1-1][y1-1]!=2) table[x1-1][y1-1]=table[x1][y1];
if (d&&l&&table[x1-1][y1+1]!=2) table[x1-1][y1+1]=table[x1][y1];
if (d&&r&&table[x1+1][y1+1]!=2) table[x1+1][y1+1]=table[x1][y1];
if (u&&r&&table[x1+1][y1-1]!=2) table[x1+1][y1-1]=table[x1][y1];
}

display(table) /*Prints out the table*/
int table[10][10];
{
int x,y;

/*	printf(CLEAR);*/
	printf("\n ");
for(x=0;x<=9;x++) printf("%d ",x);
	printf("\n");

for(y=0;y<=9;y++){
	printf("%d",y);
	for(x=0;x<=9;x++)
	if (table[x][y]==0) printf(GREEN);
	else if (table[x][y]==1) printf(RED);
	else  printf(REV); /*free place */
	printf("\n");
	}
}

main()
{
int i,j,x1,y1,x2,y2,*a1,goal=0,goal2=-1000,*b1,*xf,*yf,xfrom=0,yfrom=0,xto,yto;
char c;

status=0;
goal2=-1000;
for(i=0;i<=9;i++)
    for(j=0;j<=9;j++)
	map[j][i]=2;

/*Starting table*/
map[3][5]=1;  /*red*/
map[3][6]=1;  /*red*/
map[4][4]=1;  /*red*/
map[7][0]=0;  /*green*/
map[7][1]=0;  /*green*/
map[7][2]=0;  /*green*/

for(;;){
		display(map);
		state=status%2;
		printf("\nSTATE:%d\n",state);
		if (!state) {    /*green human player */
			printf("\nScore (You:%d Computer:%d)\n",count_green(map),count_red(map));
			printf("\nSelect coordinates (X1 Y1 X2 Y2) [%c]:",state?'R':'G');
			scanf("%d%d%d%d",&x1,&y1,&x2,&y2);
			if ((c=getchar()) == 'q') exit(0);
			/*printf(CLEAR);*/
			move (x1,y1,x2,y2);
		}
		else { /*RED MEAN COMPUTER :-) */
		printf("\nSleeping..."); /*So you can see what you have played*/
		sleep(1);

		a1=(int *)malloc(sizeof(int));
		b1=(int *)malloc(sizeof(int));
		xf=(int *)malloc(sizeof(int));
		yf=(int *)malloc(sizeof(int));
		for(i=0;i<=9;i++) /*For all the table, run alphabeta on this color*/
			for(j=0;j<=9;j++) 
				if (map[j][i]==1){
				*a1=-32000;*b1=32000;
				goal2=goal;
				goal=ab(map,j,i,0,a1,b1,xf,yf); /*call alphabeta which returns the best move found*/
				if (goal>=goal2) {xto=*xf;yto=*yf;xfrom=j;yfrom=i;} 
				/*Keep best move so far */
				}

		/*printf(CLEAR);*/
		move (xfrom,yfrom,xto,yto); /*Do the best move found*/
		}

	   }

}


/*Alpha - Beta starts here*/


/*The Alpha-Beta function*/
int ab(table,x,y,depth,a,b,xf,yf)
	int table[10][10];

	int x,y,depth,*a,*b,*xf,*yf;

{ /*a and b are pointers so the can be passed by reference */
	int x1,y1,x2,y2,fch,g,c;
	int tbls[10][10];
	if (count_free(table)==0||depth==MAXDEPTH)
		return eval(table);

	else if (state==1)
		{
		g=-32000;
		x1=x;y1=y;
		c=firstchild(&x1,&y1,table); /*returns first child's coordinates in x1 y1 and c=0 if no child exist*/
              /*c holds a value to indicate which is the child (see firstchild for details)*/
		*xf=x1;*yf=y1; /*save old x y*/
		fch=c; /*save c*/
		while (g<*b && c) { /*save table*/
			for(y2=0;y2<=9;y2++)
			 for(x2=0;x2<=9;x2++)
			   tbls[x2][y2]=table[x2][y2];
			table[x1][y1]=state;
			paint(x1,y1,table,state);
			state=0;
			g=max(g,ab(table,x1,y1,depth+1,a,b,xf,yf));
			state=1;
			for(y2=0;y2<=9;y2++) /*restore table*/
			 for(x2=0;x2<=9;x2++)
			   table[x2][y2]=tbls[x2][y2];
			if (g>*a) {(*a)=g;*xf=x1;*yf=y1;}
			table[x1][y1]=2;
			c=nextbrother(&x,&y,&x1,&y1,table,&fch); /*find next brother of x y at x1 y1 coordinates*/
									  /*fch is needed to know the previous child*/
			/*printf("\n1:a,b,g,c,depth:%d %d %d %d %d\n",*a,*b,g,c,depth);*/
		}
	}
	else { /*same comments here*/
		g=32000;
		x1=x;y1=y;
		c=firstchild(&x1,&y1,table);
		fch=c;
		if (state) state=0;else state=1;
		while (g>*a && c) {
			for(y2=0;y2<=9;y2++)
			 for(x2=0;x2<=9;x2++)
			   tbls[x2][y2]=table[x2][y2];
			table[x1][y1]=state;
			paint(x1,y1,table,state);
			state=1;
			g=min(g,ab(table,x1,y1,depth,a,b,xf,yf));
			state=0;
			for(y2=0;y2<=9;y2++)
			 for(x2=0;x2<=9;x2++)
			   table[x2][y2]=tbls[x2][y2];
			(*b)<g?(*b):g;
			if (g<*b) {(*b)=g;}
			table[x1][y1]=2;
			c=nextbrother(&x,&y,&x1,&y1,table,&fch);
		}
	}
	printf("\nReturning %d\n",g);
	return g;

}

int eval(table) /*the evaluation function, just #red-#green*/
  int table[10][10];
{ int x,y,r=0,g=0;

for(y=0;y<=9;y++){
	for(x=0;x<=9;x++)
	if (table[x][y]==0) g++;
	else if (table[x][y]==1) r++;
	}
return (r-g);
}


int firstchild(x,y,table) /*look below*/
/*first child of position x y returned at x y*/
	int table[10][10];
	int *x,*y;
{


	 if ((*y>0) && (table[*x][*y-1]==2)) {*y=*y-1;return 1;}
else if ((*y>0) && (*x<9) && (table[*x+1][*y-1]==2)) {*x=*x+1;*y=*y-1;return 2;}
else if ((*x<9) && (table[*x+1][*y]==2)) {*x=*x+1;return 3;}
else if ((*y<9) && (*x<9) && (table[*x+1][*y+1]==2)) {*x=*x+1;*y=*y+1;return 4;}
else if ((*y<9) && (table[*x][*y+1]==2)) {*y=*y+1;return 5;}
else if ((*y<9) && (*x>0) && (table[*x-1][*y+1]==2)) {*x=*x-1;*y=*y+1;return 6;}
else if ((*x>0) && (table[*x-1][*y]==2)) {*x=*x-1;return 7;}
else if ((*y>0) && (*x>0) && (table[*x-1][*y-1]==2)) {*x=*x-1;*y=*y-1;return 8;}
else if ((*y>1) && (table[*x][*y-2]==2)) {*y=*y-2;return 9;}
else if ((*x<8) && (table[*x+2][*y]==2)) {*x=*x+2;return 10;}
else if ((*y<8) && (table[*x][*y+2]==2)) {*y=*y+2;return 11;}
else if ((*x>1) && (table[*x-2][*y]==2)) {*x=*x-2;return 12;}
else return 0;
/*
this is the order childs are selected
				9

			 8  1  2

		  12 7  0  3  10

			 6  5  4

				11

*/
}



int nextbrother(x,y,x1,y1,table,i)
	int *x,*y,*i,*x1,*y1,table[10][10];
{
int j=*i; /*i is the current number of child, see diagram below*/

	 if ((j<2)  && (*y>0) && (*x<9) && (table[*x+1][*y-1]==2)) {*x1=*x+1;*y1=*y-1;j=2;}
else if ((j<3)  && (*x<9) && (table[*x+1][*y]==2))             {*x1=*x+1;*y1=*y;  j=3;}
else if ((j<4)  && (*y<9) && (*x<9) && (table[*x+1][*y+1]==2)) {*x1=*x+1;*y1=*y+1;j=4;}
else if ((j<5)  && (*y<9) && (table[*x][*y+1]==2))             {*y1=*y+1;*x1=*x;  j=5;}
else if ((j<6)  && (*y<9) && (*x>0) && (table[*x-1][*y+1]==2)) {*x1=*x-1;*y1=*y+1;j=6;}
else if ((j<7)  && (*x>0) && (table[*x-1][*y]==2))             {*x1=*x-1;*y1=*y ; j=7;}
else if ((j<8)  && (*y>0) && (*x>0) && (table[*x-1][*y-1]==2)) {*x1=*x-1;*y1=*y-1;j=8;}
else if ((j<9)  && (*y>1) && (table[*x][*y-2]==2)) {*y1=*y-2;*x1=*x;j= 9;}
else if ((j<10) && (*x<8) && (table[*x+2][*y]==2)) {*x1=*x+2;*y1=*y;j= 10;}
else if ((j<11) && (*y<8) && (table[*x][*y+2]==2)) {*y1=*y+2;*x1=*x;j= 11;}
else if ((j<12) && (*x>1) && (table[*x-2][*y]==2)) {*x1=*x-2;*y1=*y;j= 12;}
else j=0;

if (j) *i=j;

/*table[*x1][*y1]=state;
paint(*x1,*y1,table);*/

return j;
 /*next brother*/
/*this is the order brother are selected
				9

			 8  1  2

		  12 7  0  3  10

			 6  5  4

				11
*/

}



int count_free(table) /*count free blocks*/
	int table[10][10];
{
int x,y,blanks=0;
for(y=0;y<=9;y++)
	for(x=0;x<=9;x++)
		if (table[x][y]==2) blanks++;

return blanks;
}


int count_green(table)
	int table[10][10];
{
int x,y,green=0;
for(y=0;y<=9;y++)
	for(x=0;x<=9;x++)
		if (table[x][y]==0) green++;

return green;
}


int count_red(table)
	int table[10][10];
{
int x,y,red=0;
for(y=0;y<=9;y++)
	for(x=0;x<=9;x++)
		if (table[x][y]==1) red++;

return red;
}











