#include <stdio.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <unistd.h>
#define NS 10
#define TRUE 1
#define FALSE 0

struct {
	int r;
	int w;
} solin[NS];

int id;
int sum=0;
int semt[NS];

int pids[10];
int pidnum=0;
int chldead=0;

void sighdl();

writevar(k,value)
int k,value;
{
	int r,i;

	read(solin[k].r,&i,sizeof(i));
	r=write(solin[k].w,&value,sizeof(value));
	return r;
}

readvar(k)
int k;
{
	int r,i;

	read(solin[k].r,&i,sizeof(i));
	write(solin[k].w,&i,sizeof(i));
	return i;
}

sharedvar(k,init)
int k,init;
{
	int r,fild[2];


	if (!(r=pipe(fild))) {
		solin[k].r=fild[0];
		solin[k].w=fild[1];
		if (write(solin[k].w,&init,sizeof(init))<1) perror("sharedvar");
	}
	else 
		perror("sharedvar");
	return r;
}

pfork(nproc)
int nproc;
{
	int i,j,f=1;

	pidnum=nproc;
	for (i=0;i<nproc-1;i++) {
		if (f>0) {
			f=fork();
			pids[i]=f;
		}
		else
			break;
	}

	return (f>0?0:i);
}

pjoin(nproc,id)
int nproc,id;
{
	int i;

	if (id) exit(0);
	else 
		for (i=0;i<nproc-1;i++)
			wait(0);

}




void usleep(long x) {

	struct timeval	time;

	time.tv_sec=x/1000000;
	time.tv_usec=x%1000000;
	select(0, NULL, NULL, NULL, &time);
}


main()
{
	int i,j,nproc=5,k=1;
	int size=100;
	int table[size];



	for(i=0;i<size;i++) table[i]=i;

	sharedvar(k,0);
	id=pfork(nproc);

	if (id>0)
			semt[0]=semopen(5000,FALSE,1);
	else 
			semt[0]=semopen(5000,TRUE,1);

	signal(SIGALRM,sighdl);
	alarm(1);

	for (i=id;i<size;i+=nproc) {
		sum+=table[i];
		usleep((long)200000);

	}
	semwait(semt[0]);
	writevar(k,readvar(k)+sum);
	semsignal(semt[0]);

	pjoin(nproc,id);
	semclose(semt[0]);
	printf("\nRESULT:%d\n",readvar(k));

	printf("\nID:%d END\n",id);

}


void sighdl()
{

	printf("ID:%d has SUM:%d\n",id,sum);
	signal(SIGALRM,sighdl);
	alarm(1);
}
