#include "definitions.h"
#include "defs.h"

WINDOW *mybox=0;


#define HEADER "GoodTiMeS Database  (C) Ioannou Spiros, Papagiannaki Dina "
#define PROMPT "Press highlighted letter or RETURN to verify current selection"

void interface_init()
/* Initialise user-interface */
{
	initscr(); /*Always the first function called */
	cbreak();  /*Do not store chars into tty driver buffer*/
	noecho();  /*do not echo chars read with getch*/
	/*nonl();    /*CR=NL, disable translations=>faster cursor motion*/
	intrflush(stdscr, FALSE); /*Flush buffers on onint */
	keypad(stdscr, TRUE);     /*Enable key pad (arrow keys)*/
	do_title(0,HEADER);
}

void show_h_histogram()
{
int i=0,j=0,k=0,max=0;
char *format;

 clear();
 refresh();
  if (3*bigtable_h[0].m>(LINES-2)) {printf("Too many lines - resize your window\n");refresh();sleep(1);return;}
 /*Find max*/
 for (i=1;i<=bigtable_h[0].m;i++)
    if (bigtable_h[i].m>max) max=bigtable_h[i].m;

 for (i=1;i<=bigtable_h[0].m;i++) {
  mvprintw(3*i,1,"%10s",&bigtable_h[i].d);
  if (bigtable_h[i].m) {
    for (j=0;j<(float)(bigtable_h[i].m)/max*(COLS-20)&&j<COLS-20;j++)
	{
	mvaddch(3*i,(j+12),' '|A_STANDOUT);
	}
  }
	mvprintw(3*i,COLS-7,"%-5d",bigtable_h[i].m);
 }
 move(LINES-2,1);
 do_title(LINES-2,"TOTAL MONEY EARNED PER MONTH");
 refresh();
}


void show_histogram()
{
int i=0,j=0,k=0,max=0;
char *format;
extern int bigtable[];

 clear();
 refresh();
 /*Find max*/
 for (i=1;i<=bigtable[0];i++)
    if (bigtable[i]>max) max=bigtable[i];

 for (i=1;i<=bigtable[0]&&i<COLS/4;i++) {
  if (i<10) format="  %d "; else format=" %d ";
  mvprintw(LINES-3,4*(i-1),format,i);
  if (bigtable[i]) {
    for (j=0;j<(float)(bigtable[i])/max*(LINES-10)&&j<LINES-10;j++)
	{
	for (k=1;k<4;k++)
	mvaddch(LINES-(j+5),4*i-k,' '|A_STANDOUT);
	mvprintw(LINES-(j+6),4*i-4,"%4d",bigtable[i]);
	}
  }
 }
 move(LINES,1);
 do_title(LINES-2,"RENTS PER CLIENT");
 refresh();
}


static void draw_menu (entry *current_menu)
{
	int i;
	/* Menu title... */
	do_title(3,current_menu[0].prompt);

	/* Menu entries */
	for (i=2; current_menu[i].prompt; i++) {
		move(i+4,10); /*Go where needed*/
		addstr(current_menu[i].prompt); /*Write menu string*/
		move(i+4,10+current_menu[i].where); /*Go to highlited letter*/
		addch(current_menu[i].hotkey|A_BOLD); /*Highlight it*/
	}

	/* Standard entries... */
	move(LINES-6,10);
	addch('M'|A_BOLD); addstr("ain     ");
	addch('P'|A_BOLD); addstr("revious    ");
	addch('e'); addch('X'|A_BOLD); addstr("it");
	move(LINES-6,50);
	addch('H'|A_BOLD); addstr("elp      	");
	addch('A');addch('b'|A_BOLD); addstr("out		");

	/* Prompt */
	move(LINES-2, 10);
	addstr(PROMPT);

	standout();
	i=5;
	move(i,10);
	addstr(current_menu[1].prompt);
	move(5,current_menu[1].where+10);
	standend();
	refresh();
}

int menu(entry *current_menu)
{
	int i,ch, rv,position=1;

	draw_menu(current_menu);

	for(;;) {

		ch =getch();
		if (isalpha(ch))
		    for (i=1; current_menu[i].prompt; i++) {
			if (tolower(ch)==tolower(current_menu[i].hotkey))  {
					position=i;
					ch='\n';
			}
		    }
		switch (ch) {

		case 'p':
		case 'P':
		case KEY_LEFT:

			return NORMAL;
			break;

		case KEY_UP:
		case KEY_DOWN:

			move(position+4,10);
			clrtoeol();
			addstr(current_menu[position].prompt);
			move(position+4,10+current_menu[position].where);
			addch(current_menu[position].hotkey|A_BOLD);

			if (ch==KEY_DOWN)
				if (!current_menu[++position].prompt) position--;
			if (ch==KEY_UP)
				if (position!=1) position--;

			move(position+4,10);
			clrtoeol();
			standout();
			addstr(current_menu[position].prompt);
			move(position+4,10+current_menu[position].where);
			standend();
			refresh();
			break;

		case KEY_RIGHT:
		case '\n':
			if (current_menu[position].sub_menu) {
				rv = menu(current_menu[position].sub_menu);
				if (rv == NORMAL) {
					clearok(stdscr,TRUE);
					refresh();
					position=1;
					draw_menu(current_menu);
					break;
				}
				else return rv;
			}
			else {
				clear();
				refresh();
				endwin();
				(current_menu[position].function)();
				printf("\nPRESS RETURN TO CONTINUE\n");
				getchar();
				clearok(stdscr,TRUE); /*Redraw all on refresh*/
				position=1;
				draw_menu(current_menu);
				refresh();
				break;
			}
			/* Standard choices...*/
		case 'x':
		case 'X':
			if (dialog_box("REALLY QUIT ?")) return EXIT;
			draw_menu(current_menu);
			clearok(stdscr,TRUE);
			refresh();
			break;
		case 'B':
		case 'b':
			about();
			break;
		case 'H':
		case 'h':
			help();
			break;
		case 'M':
		case 'm':
			return MAIN;
			break;
		default:
			beep();
			break;
		}
	        refresh();
	}
}

void help()
{
        endwin();
        system("cat help.box");
	printf("                       PRESS RETURN TO CONTINUE...");
	getch();
	refresh();
}

void about()
{
        endwin();
        system("cat about.box");
	printf("                       PRESS RETURN TO CONTINUE...");
	getch();
	refresh();
}

void interface_shutdown()
{
/* Shutdown user-interface */
	clear();
	refresh();
	endwin();
	exit(0);
}

int dialog_box(char *prompt)
{
	int answer=TRUE;
	if (!mybox)
		mybox=newwin(8,30,LINES/2-4,COLS/2-15);
	else wclear(mybox);
	wstandout(mybox);
	mvwaddstr(mybox,1,15-strlen(prompt)/2, prompt);
	wstandend(mybox);
	keypad(mybox,TRUE);
	box(mybox,' '|A_STANDOUT,' '|A_STANDOUT);

	wstandout(mybox);
	mvwaddstr(mybox, 5, 6,"OK");
	wstandend(mybox);
	mvwaddstr(mybox, 5, 20, "CANCEL");

	wmove(mybox,5,6);
	wrefresh(mybox);


	for(;;)
		switch (mvwgetch(mybox,5,5))
		{
		case KEY_RIGHT:
			answer=FALSE;
			mvwaddstr(mybox, 5, 6,"OK");
			wstandout(mybox);
			mvwaddstr(mybox, 5, 20, "CANCEL");
			wstandend(mybox);
			wmove(mybox,5,20);
			wrefresh(mybox);
			break;
		case KEY_LEFT:
			answer=TRUE;
			wstandout(mybox);
			mvwaddstr(mybox, 5, 6,"OK");
			wstandend(mybox);
			mvwaddstr(mybox, 5, 20, "CANCEL");
			wmove(mybox,5,6);
			wrefresh(mybox);
			break;
		case '\n':
			goto OVER;
		default:
			beep();
			break;
		}
OVER:
	overwrite(stdscr,mybox);
	refresh();
	return answer;
}


/*
 * FROM definitions.h
 * 
 *  typedef struct entry {
	    char    *prompt;
	    int     where;
	    char    hotkey;
	    struct entry *sub_menu;
	    void    (*function) ();
 *  } entry;
 *
 */

entry actions[] = {
	{ "ACTIONS MENU",0, ' ', 0, 0 },
	{ "Show all rentals",0, 'S',0,outrents },
	{ "Rent a house",0, 'R',0, renthouse},
	{ "End a house's rental",0, 'E',  0,releasehouse },
	NULL_ENTRY
};
entry clients[] = {
	{ "CLIENT MENU",0, ' ', 0, 0 },
	{ "Show all clients",0, 'S',0, outclients},
	{ "Add client",0, 'A',0,addclient },
	{ "Modify client",1, 'o',0,modifyclient },
	{ "Delete client",0, 'D',  0,delclient },
	{ "Find client name by id",0, 'F',  0,relatename},
	{ "Relate a client name to its id", 0, 'R', 0, nametokey},
	NULL_ENTRY
};
entry statistics_menu[] = {
	{ "STATISTICS MENU",0, ' ', 0, 0 },
	{ "Show how many days a house is rented",14, 'd',0,showdays },
	{ "Show ammount of money earned",5, 'a',  0,total },
	{ "Show free houses between two dates",5, 'f',  0,showfree },
	{ "Show important clients",5, 'i',  0,showimp },

	NULL_ENTRY
};
entry houses[] = {
	{ "HOMES MENU",0, ' ', 0, 0 },
	{ "Show all houses",0, 'S',  0,outhouses },
	{ "Add house",0, 'A',0,addhouse },
	{ "Modify house",1, 'o',0,modifyhouse },
	{ "Delete house",0, 'D',  0,delhouse },
	{ "Find house address by id",0, 'F',0, relateaddress},
	{ "Relate a house's address to its id", 0, 'R', 0, addresstokey},
	NULL_ENTRY
};
entry first[] = {
	{ "MAIN MENU",0, ' ', 0, 0 },
	{ "Houses",1, 'o',houses,0 },
	{ "Clients",0, 'C',  clients,0 },
	{ "Actions",0, 'A',  actions,0 },
	{ "Statistics",0, 'S',  statistics_menu,0 },
	NULL_ENTRY
};

int main()
{

	dbase_init();
	interface_init();
	show_intro();
	while (menu(first)!=EXIT);
	interface_shutdown();
	return 0;
}

