#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include "pvm3.h"
#include "ask1.h"


int cpp; /*Columns per process*/
int nproc=4;
int numt;
int tids[4];
int left,right,i,j,k;
float *tbl;

/*
int	B ;
unsigned long    LOOPS;
float	C;
float	a1, a2, a3, a4;
*/
float	*A;

void  cleanup();

#define  M(X, Y)  *(A+B*(X)+(Y))
#define  TB(X, Y)  *(tbl+B*(X)+(Y))

void getinput() {

	if (B<0)
		do {
			printf("Grid size (B) : ");
			fflush(stdout);
			scanf("%u", &B);
			if (B<2)
				printf("\nB >= 2\n");
		} while (B<2);

	if(C<0)
		do {
			printf("Dt/Dx^2 (C) : ");
			fflush(stdout);
			scanf("%f", &C);
		} while ((C<=0.0) || (C>=0.5));

	if (LOOPS<0)
		do {
			printf("Loops (LOOPS) : ");
			fflush(stdout);
			scanf("%ld", &LOOPS);
		} while (LOOPS<0);

	if (a1<0){
		printf("A(t,B,y) = ");
		fflush(stdout);
		scanf("%f", &a1);
	}

	if (a2<0){
		printf("A(t,0,y) = ");
		fflush(stdout);
		scanf("%f", &a2);
	}

	if (a3<0){
		printf("A(t,x,0) = ");
		fflush(stdout);
		scanf("%f", &a3);
	}

	if (a4<0){
		printf("A(t,x,B) = ");
		fflush(stdout);
		scanf("%f", &a4);
	}
}

void initmatrix() {
	int	i, B2 = B*B;

	printf("Allocating memory...\n");
	fflush(stdout);
	A = (float *) malloc(sizeof(float)*B*B);

	if (A==NULL) {
		fprintf(stderr,"master:Not engough free memory.\n");
		perror("malloc");
		cleanup();
		exit(4);
	}

	/*Zero table*/
	for (i=0; i<B2; i++)  *(A + i)= 0;

	for (i=0; i<B; i++) {
		M(B-1, i) = a1; /*Down*/
		M(0, i) = a2;   /*Up*/
	}

	for (i=0; i<B; i++) {
		M(i, 0) = a3;   /*Left*/
		M(i, B-1) = a4; /*Right*/
	}


	/*Set corner values*/
	M(0,0)=(M(0,1)+M(1,0))/2.0;
	M(B-1,B-1)=(M(B-2,B-1)+M(B-1,B-2))/2.0;
	M(0,B-1)=(M(0,B-2)+M(1,B-1))/2.0;
	M(B-1,0)=(M(B-2,0)+M(B-1,1))/2.0;
}

void cleanup() {
	if (A) free(A);
	fprintf(stderr,"\nmaster:Freed allocated memory...\n");
}

void printMatrix() {
	int	x,y;
	float	*curr;
	int	fsz;
	FILE *fp;

	if ((fp=fopen("/tmp/out.dat","w"))==0) {
		perror("ERROR:out.dat");
		exit(44);
	}


	for (y=0; y<B; y++) {
		for (x=0; x<B; x++) {
			fprintf(fp,"%2.2f\n", M(x,y));
		}
		fprintf(fp,"\n");
	}

}

#define SLAVENAME "ask1slave"

main() {
	/*
	  cpp : columns per process
	*/

	getinput();
	initmatrix();

	if ((B-2)%nproc) {
		fprintf(stderr,"B-2=%2 not dividable by %d\n",B-2,nproc);
		exit(6);
	}

	tbl = (float *) malloc(sizeof(float)*B*B);
	cpp=(B-2)/nproc;


	numt=pvm_spawn(SLAVENAME, (char**)0, 0, "", nproc, tids);
	if( numt < nproc ){
		printf("\n Trouble spawning slaves. Aborting. Error codes are:\n");
		fflush(stdout);
		for( i=numt ; i<nproc ; i++ ) {
			printf("TID %d %d\n",i,tids[i]);
			fflush(stdout);
		}
		for( i=0 ; i<numt ; i++ ){
			pvm_kill( tids[i] );
		}
		pvm_exit();
		exit(1);
	}
	printf("SUCCESSFULL\n");
	fflush(stdout);


	/*Send general info + table A + size + loops*/
	pvm_initsend(PvmDataDefault);
	pvm_pkint(&nproc,1,1);
	pvm_pkint(tids,nproc,1);
	pvm_pkint(&B,1,1);
	pvm_pkfloat(&C,1,1);
	pvm_pkfloat(A,(B*B),1);
	pvm_pkulong(&LOOPS,1,1);
	pvm_mcast(tids,nproc,0);



	/*Send borders to each child*/
	for (k=1,i=0;i<nproc;i++) {
		left=k;
		right=k+cpp-1;
		pvm_initsend(PvmDataDefault);
		pvm_pkint(&left,1,1);
		pvm_pkint(&right,1,1);
		pvm_send(tids[i],1);
		k=k+cpp;
	}


	/*Receive results from each child*/
	for (k=1,i=0;i<nproc;i++) {
		pvm_recv(tids[i],10);
		pvm_upkfloat(tbl,B*B,1);
		updateMCols(k,k+cpp-1);
		k=k+cpp;
	}

	fflush(stdout);
	printMatrix();
	cleanup();

	pvm_exit();
}

updateMCols(int leftcol,int rightcol) {
	int i,j,k;

	for(j=0;j<B-1;j++) {
		for (k=leftcol;k<=rightcol;k++)
			M(j,k)=TB(j,k);
	}
}

