#include <stdio.h>
#include <stdlib.h>
#include "pvm3.h"

int left,right,tids[4],me,nproc=4,mytid,B; /*globals*/

int	B ;
unsigned long    LOOPS;
float	C;
#define SIZE 50

float	a1, a2, a3, a4;
float	A[SIZE][SIZE],L[SIZE],LL[SIZE],LR[SIZE],LS[SIZE];

float getM();
void  cleanup();

#define  M(X, Y)  *(A+B*(X)+(Y))

/*
#define  N(X)   *(L+(X))
#define  VL(X)  *(LL+(X))
#define  VR(X)  *(LR+(X))
#define  VS(X)  *(LS+(X))
*/


void initmatrix() {
	int	i,j, B2 = B*B;
	/*
		printf("Allocating memory...\n");
		fflush (stdout);
		A = (float *) malloc(sizeof(float)*B*B);
		L = (float *) malloc(sizeof(float)*B);
		LL = (float *) calloc(B,sizeof(float));
		LR = (float *) calloc(B,sizeof(float));
		LS = (float *) calloc(B,sizeof(float));
	
	
	
		if (A==NULL||L==NULL||LL==NULL||LR==NULL||LS==NULL) {
			printf("slave:Not engough free memory.\n");
			cleanup();
			exit(4);
		}
		for (i=0; i<B2; i++)  *(A + i)= 0;
	*/

	for (i=0; i<B; i++)
		for (j=0; j<B; j++)  A[i][j] = 0;


	for (i=0; i<B; i++) {
		A[B-1][i] = a1; /*Down*/
		A[0][i] = a2;   /*Up*/
	}

	for (i=0; i<B; i++) {
		A[i][0] = a3;   /*Left*/
		A[i][B-1] = a4; /*Right*/
	}


	/*Set corner values*/
	A[0][0]=(A[0][1]+A[1][0])/2.0;
	A[B-1][B-1]=(A[B-2][B-1]+A[B-1][B-2])/2.0;
	A[0][B-1]=(A[0][B-2]+A[1][B-1])/2.0;
	A[B-1][0]=(A[B-2][0]+A[B-1][1])/2.0;
}

void cleanup() {
	/*
		if (A) free(A);
		if (L) free(L);
		if (LL) free(LL);
		if (LR) free(LR);
		if (LS) free(LS);
		printf("\nslave:Freed allocated memory...\n");
		*/
}

void printMatrix() {
	int	x,y;

	for (y=0; y<B; y++)
		printf("\t%d",y);
	printf("\n    ");
	for (y=0; y<8*B; y++)
		printf("-",y);
	for (x=0; x<B; x++) {
		printf("\n%2d |\t",x);
		for (y=0; y<B; y++) {
			printf("%2.2f\t", A[x][y]);
		}
		printf("\n   |");
	}

	scanf("");
}

void expandHeat(int leftcol,int rightcol) {
	int j,k;
	float prevMjk=-5.00;


	for(j=0;j<B-1;j++) {
		/*N(k) saves last value to be available for next heatSpot*/
		for (k=leftcol;k<=rightcol;k++)
		{

			prevMjk=A[j][k]; /*Nk contains A[j-1],[k] (Up) needed below */
			/*So don't overwrite it now*/
			/* printf("Prev%d,%d=%f\n",j,k,prevMjk);*/
			if (j) heatSpot(j,k,leftcol,rightcol);
			L[k]=prevMjk; /*Update Nk,now contains M(j,k)*/
		}
	}
}

heatSpot(int j,int k,int leftcol,int rightcol) {

	/*
	  printf("Before:%d,%d\nThis:%f,\nDown:%f,\nUp  :%f,\nLeft:%f,\nRight%f\n",j,k,
			M(j,k),
			M(j+1,k),
			getM(j-1,k,1,leftcol,rightcol),
			getM(j,k-1,2,leftcol,rightcol),
			getM(j,k+1,3,leftcol,rightcol));
	
	fflush(stdout);
	*/

	A[j][k]=(A[j][k]+(float)(C)*(
	    A[j+1][k]+                       /*Down*/
	getM(j-1,k,1,leftcol,rightcol)+ /*Up*/
	getM(j,k-1,2,leftcol,rightcol)+ /*Left*/
	getM(j,k+1,3,leftcol,rightcol)- /*Right*/
	(float)4.0*A[j][k]));
	/*
	  printf("After:%d,%d\nThis:%f,\nDown:%f,\nUp  :%f,\nLeft:%f,\nRight%f\n\n",j,k,
			A[j][k],
			A[j+1][k],
			getM(j-1,k,1,leftcol,rightcol),
			getM(j,k-1,2,leftcol,rightcol),
			getM(j,k+1,3,leftcol,rightcol));
	
	fflush(stdout);
	
	*/
	return 1;
}

float getM(int j,int k,int place,int leftcol,int rightcol) {

	if (k==0 || k==B-1)
		return A[j][k];
	else if (place==1) {  /*Up*/
		if (j==0)
			return A[j][k];
			else
			return L[k];
	}
	else if (place==2) { /*Left*/
		if (k+1==leftcol)
			return LL[j];
			else
			return L[k];
	}
	else if (place==3) { /*Right*/
		if (k-1==rightcol) {
			return LR[j];
		}
		else
			return A[j][k];
	}
	else {
		printf("\nError 1: j:%d,k:%d,leftcol:%d,rightcol:%d\n",
		    j,k,leftcol,rightcol);
		fflush(stdout);
		return -2;
	}
}


main() {
	int i,j,parent;

	nproc=4;

	initmatrix();
	mytid=pvm_mytid();
	parent=pvm_parent();

	/*Get general info*/
	pvm_recv(parent,0);
	pvm_upkint(&nproc,1,1);
	pvm_upkint(tids,nproc,1);
	pvm_upkint(&B,1,1);
	pvm_upkfloat(&C,1,1);

	pvm_upkfloat(&A[0][0],(B*B),1);
	pvm_upkulong(&LOOPS,1,1);

	fprintf(stderr,"0:nproc:%d,B:%d,C:%f,LOOPS:%ld\n",nproc,B,C,LOOPS);


	/*Get borders*/
	pvm_recv(parent,1);
	pvm_upkint(&left,1,1);
	pvm_upkint(&right,1,1);
	fprintf(stderr,"1:left:%d,right:%d\n",left,right);



	for( i=0; i<nproc ; i++ )
		if( mytid == tids[i] ) { 
			me = i; 
			break; 
		}
	fprintf(stderr,"me=%d\n",me);

	/*
	if (!me)
	  printMatrix();
	*/

	if (left==1)
		for (j=0;j<B;j++) LL[j]=A[j][0];

	if (right==B-2)
		for (j=0;j<B;j++) LR[j]=A[j][B-1];


	for (i=0; i<LOOPS; i++) {
		expandHeat(left,right);
		if (left!=1)    sendL(me-1);
		if (right!=B-2) sendR(me+1);

		if (left!=1)    getVL(me-1);
		if (right!=B-2) getVR(me+1);

	}


	pvm_initsend(PvmDataDefault);
	pvm_pkfloat(&A[0][0],(B*B),1);
	pvm_send(parent,10);
	cleanup();

	pvm_exit();

}

getVL(int org) { /*3*/

	pvm_recv(tids[org],3);
	pvm_upkfloat(LL,B,1);

}

getVR(int org) { /*2*/

	pvm_recv(tids[org],2);
	pvm_upkfloat(LR,B,1);

}


sendL(int dest){ /*2*/
	int j;
	for(j=0;j<B-1;j++) {
		LS[j]=A[j][left];
	}
	pvm_initsend(PvmDataDefault);
	pvm_pkfloat(LS,B,1);
	pvm_send(tids[dest],2);
}

sendR(int dest){ /*3*/
	int j;
	for(j=0;j<B-1;j++) {
		LS[j]=A[j][right];
	}
	pvm_initsend(PvmDataDefault);
	pvm_pkfloat(LS,B,1);
	pvm_send(tids[dest],3);
}
